/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.appspace.VWAppSpaceSecurityPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.images.VWBaseImageLoader;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.uicontrols.security.VWItemFilterPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

class VWAppSpaceFilteredSecurityPanel
extends VWAppSpaceSecurityPanel
implements ActionListener {
    protected int m_nType = 0;
    protected JRadioButton m_groupsRadioButton;
    protected JRadioButton m_usersRadioButton;
    protected VWItemFilterPanel m_itemFilterPanel;

    public VWAppSpaceFilteredSecurityPanel(Container parentContainer, VWSessionInfo sessionInfo, VWApplicationSpaceDefinition appSpaceDef) {
        super(parentContainer, sessionInfo, appSpaceDef);
        this.m_enableTypeAhead = false;
        this.setAvailableItemName(VWResource.s_availableUsers);
        this.setSelectedItemName(VWResource.s_selectedUsers);
    }

    public void releaseResources() {
        if (this.m_groupsRadioButton != null) {
            this.m_groupsRadioButton.removeActionListener(this);
            this.m_groupsRadioButton = null;
        }
        if (this.m_usersRadioButton != null) {
            this.m_usersRadioButton.removeActionListener(this);
            this.m_usersRadioButton = null;
        }
        super.releaseResources();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_groupsRadioButton)) {
                if (this.m_nType != 1 && this.m_itemFilterPanel != null) {
                    this.m_itemFilterPanel.clear();
                }
                this.m_nType = 1;
                this.initializeLists(null, this.getSelectedItems());
            } else if (event.getSource().equals(this.m_usersRadioButton)) {
                if (this.m_nType != 0 && this.m_itemFilterPanel != null) {
                    this.m_itemFilterPanel.clear();
                }
                this.m_nType = 0;
                this.initializeLists(null, this.getSelectedItems());
            } else if (event.getSource().equals(this.m_itemFilterPanel)) {
                switch (this.m_nType) {
                    case 0: {
                        this.initializeLists(this.m_itemFilterPanel.getUserParticipantItems(), this.getSelectedItems());
                        break;
                    }
                    case 1: {
                        this.initializeLists(this.m_itemFilterPanel.getGroupParticipantItems(), this.getSelectedItems());
                    }
                }
            } else {
                super.actionPerformed(event);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_parentContainer, ex.getLocalizedMessage(), VWResource.s_error, 0);
        }
    }

    protected void addControls() {
        try {
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 3;
            gbCons.gridheight = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 3, 3);
            JPanel headerPanel = this.getHeaderPanel();
            this.add((Component)headerPanel, gbCons);
            VWAccessibilityHelper.setAccessibility(headerPanel, this, VWResource.s_showAvailable, VWResource.s_showAvailable);
            JPanel panel = new JPanel();
            this.m_itemFilterPanel = new VWItemFilterPanel(this.m_parentContainer, this.m_vwSession);
            this.m_itemFilterPanel.addActionListener(this);
            this.m_itemFilterPanel.requestFocus();
            this.m_availableList = new JList(new VWSortedListModel());
            this.m_availableList.addListSelectionListener(this);
            this.m_availableList.addMouseListener(new VWMouseAdapter(this));
            JScrollPane availableListPane = new JScrollPane(this.m_availableList);
            VWAccessibilityHelper.setAccessibility(this.m_availableList, this, VWResource.s_availableList, VWResource.s_availableList);
            this.m_availableList.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 23;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(3, 3, 3, 3);
            panel.add((Component)this.m_availableLabel, gbc);
            VWAccessibilityHelper.setAccessibility(this.m_availableLabel, this, this.m_availableLabel.getText(), this.m_availableLabel.getText());
            this.m_availableLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbc.gridy;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            panel.add((Component)this.m_itemFilterPanel, gbc);
            ++gbc.gridy;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            panel.add((Component)availableListPane, gbc);
            gbCons.gridwidth = 2;
            gbCons.gridheight = 3;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            gbCons.weightx = 0.5;
            this.add((Component)panel, gbCons);
            gbCons.anchor = 10;
            gbCons.gridx += gbCons.gridwidth;
            gbCons.gridwidth = 1;
            gbCons.fill = 3;
            gbCons.weightx = 0.0;
            this.add((Component)this.createAddRemoveButtonPanel(), gbCons);
            ++gbCons.gridx;
            ++gbCons.gridy;
            gbCons.gridwidth = 2;
            gbCons.gridheight = 3;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            this.m_selectedList = new JList(new VWSortedListModel());
            this.m_selectedList.addListSelectionListener(this);
            this.add((Component)this.createSelectedListPanel(this.m_selectedList), gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_selectedList, this, VWResource.s_selectedList, VWResource.s_selectedList);
            this.m_selectedList.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getHeaderPanel() {
        try {
            JPanel headerPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 0, 2);
            JLabel showAvailableLabel = new JLabel(VWResource.s_showAvailableColon);
            headerPanel.add((Component)showAvailableLabel, gbCons);
            VWAccessibilityHelper.setAccessibility(showAvailableLabel, headerPanel, VWResource.s_showAvailable, VWResource.s_showAvailable);
            VWAccessibilityHelper.setLabelFor(showAvailableLabel, headerPanel);
            showAvailableLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbCons.gridx;
            gbCons.insets = new Insets(0, 3, 0, 0);
            this.m_usersRadioButton = new JRadioButton(VWResource.s_Users);
            this.m_usersRadioButton.setSelected(true);
            this.m_usersRadioButton.addActionListener(this);
            ButtonGroup filterGroup = new ButtonGroup();
            headerPanel.add((Component)this.m_usersRadioButton, gbCons);
            VWAccessibilityHelper.setMemberOf(this.m_usersRadioButton, filterGroup);
            VWAccessibilityHelper.setAccessibility(this.m_usersRadioButton, headerPanel, VWResource.s_Users, VWResource.s_Users);
            this.m_usersRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_groupsRadioButton = new JRadioButton(VWResource.s_Groups);
            this.m_groupsRadioButton.addActionListener(this);
            headerPanel.add((Component)this.m_groupsRadioButton, gbCons);
            VWAccessibilityHelper.setMemberOf(this.m_groupsRadioButton, filterGroup);
            VWAccessibilityHelper.setAccessibility(this.m_groupsRadioButton, headerPanel, VWResource.s_Groups, VWResource.s_Groups);
            this.m_groupsRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            return headerPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createAddRemoveButtonPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.anchor = 10;
            gbConst.fill = 0;
            gbConst.gridx = 0;
            gbConst.gridy = -1;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(3, 0, 3, 0);
            if (this.m_bShowMoveAllButtons) {
                this.m_addAllButton = new JButton(VWImageLoader.createImageIcon("addall.gif"));
                this.m_addAllButton.setDisabledIcon(VWImageLoader.createImageIcon("addall_d.gif"));
                this.m_addAllButton.setToolTipText(VWResource.s_addAll);
                this.m_addAllButton.setMargin(new Insets(1, 1, 1, 1));
                this.m_addAllButton.addActionListener(this);
                VWBaseImageLoader.enableIconComponentOrientation(this.m_addAllButton);
                panel.add((Component)this.m_addAllButton, gbConst);
                VWAccessibilityHelper.setAccessibility(this.m_addAllButton, this, VWResource.s_addAll, VWResource.s_addAll);
                this.m_addAllButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
            this.m_addButton = new JButton(VWImageLoader.createImageIcon("add.gif"));
            this.m_addButton.setDisabledIcon(VWImageLoader.createImageIcon("add_d.gif"));
            this.m_addButton.setToolTipText(VWResource.s_add);
            this.m_addButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_addButton.addActionListener(this);
            VWBaseImageLoader.enableIconComponentOrientation(this.m_addButton);
            panel.add((Component)this.m_addButton, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_addButton, this, VWResource.s_add, VWResource.s_add);
            this.m_addButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createSelectedListPanel(JList selectedList) {
        try {
            JPanel sListPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 0, 2);
            sListPanel.add((Component)this.m_selectedLabel, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_selectedLabel, this, this.m_selectedLabel.getText(), this.m_selectedLabel.getText());
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            this.m_removeButton = VWImageLoader.createToolBarButton("delete.gif", VWResource.s_delete, false);
            this.m_removeButton.addActionListener(this);
            sListPanel.add((Component)this.m_removeButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_removeButton, this, VWResource.s_delete, VWResource.s_delete);
            --gbCons.gridx;
            ++gbCons.gridy;
            gbCons.gridwidth = 2;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            sListPanel.add((Component)new JScrollPane(selectedList), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weighty = 0.0;
            return sListPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected VWParticipantItem[] createAvailableItemArray() throws Exception {
        return null;
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        return null;
    }
}

